import React from "react";
import { useLanguage } from "@/contexts/LanguageContext";
import { SystemAnalysisData } from "@/types/analysis";

interface OverviewTabProps {
  systemData: SystemAnalysisData;
}

export default function OverviewTab({ systemData }: OverviewTabProps) {
  const { t } = useLanguage();
  return (
    <>
      <div className='grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8'>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.totalTickets") || "Total Tickets"}
          </h3>
          <p className='text-2xl font-bold text-gray-900'>
            {systemData.ticketStats.totalTickets}
          </p>
        </div>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.openTickets") || "Open Tickets"}
          </h3>
          <p className='text-2xl font-bold text-orange-600'>
            {systemData.ticketStats.openTickets}
          </p>
        </div>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.inProgress") || "In Progress"}
          </h3>
          <p className='text-2xl font-bold text-blue-600'>
            {systemData.ticketStats.inProgressTickets}
          </p>
        </div>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.completed") || "Completed"}
          </h3>
          <p className='text-2xl font-bold text-green-600'>
            {systemData.ticketStats.completedTickets}
          </p>
        </div>
      </div>

      <div className='grid grid-cols-1 md:grid-cols-4 gap-6 mb-8'>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.today") || "Today"}
          </h3>
          <p className='text-2xl font-bold text-gray-900'>
            {systemData.timeStats.todayTickets}
          </p>
        </div>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.thisWeek") || "This Week"}
          </h3>
          <p className='text-2xl font-bold text-gray-900'>
            {systemData.timeStats.weekTickets}
          </p>
        </div>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.thisMonth") || "This Month"}
          </h3>
          <p className='text-2xl font-bold text-gray-900'>
            {systemData.timeStats.monthTickets}
          </p>
        </div>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-sm font-medium text-gray-500'>
            {t("analysis.avgPerDayOverview") || "Avg/Day"}
          </h3>
          <p className='text-2xl font-bold text-gray-900'>
            {systemData.timeStats.avgTicketsPerDay}
          </p>
        </div>
      </div>

      <div className='grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8'>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-lg font-semibold mb-4'>
            {t("analysis.averageResolutionTime") || "Average Resolution Time"}
          </h3>
          <p className='text-3xl font-bold text-blue-600'>
            {systemData.ticketStats.averageResolutionTime}h
          </p>
          <p className='text-sm text-gray-500 mt-2'>
            {t("analysis.timeFromStart") || "Time from start to completion"}
          </p>
        </div>
        <div className='bg-white p-6 rounded-lg shadow'>
          <h3 className='text-lg font-semibold mb-4'>
            {t("analysis.ticketStatusDistribution") ||
              "Ticket Status Distribution"}
          </h3>
          <div className='space-y-2'>
            <div className='flex justify-between'>
              <span className='text-sm text-gray-600'>
                {t("tickets.statusValues.open")}
              </span>
              <span className='text-sm font-medium'>
                {systemData.ticketStats.openTickets}
              </span>
            </div>
            <div className='flex justify-between'>
              <span className='text-sm text-gray-600'>
                {t("tickets.statusValues.inProgress")}
              </span>
              <span className='text-sm font-medium'>
                {systemData.ticketStats.inProgressTickets}
              </span>
            </div>
            <div className='flex justify-between'>
              <span className='text-sm text-gray-600'>
                {t("analysis.completed")}
              </span>
              <span className='text-sm font-medium'>
                {systemData.ticketStats.completedTickets}
              </span>
            </div>
            <div className='flex justify-between'>
              <span className='text-sm text-gray-600'>
                {t("tickets.statusValues.closed")}
              </span>
              <span className='text-sm font-medium'>
                {systemData.ticketStats.closedTickets}
              </span>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
